clear
clc

x1=1000;
y1=1000;

%%%%%%%%%%%     c0=[x2,y2,x3,y3,...,x10,y10]
c0=[1050.41963241946,982.737501423708,1011.51726922498,1039.15954286262,1036.60561270112,1078.75645748059,1005.22357558925,1068.00768722772,1024.13298352289,1105.67749797650,1034.38763739674,1129.09131430207,1022.62173102220,1143.92240843385,1088.01633425103,1146.52782244219,1079.26493385029,1191.68340469583];

%%%%%%%%%%%     L=[s1-s2,s1-s3,s1-s5,...,s9-s10,G,alfa]
L=[53.2929;40.8181;68.208;68.5335;97.2;46.8758;29.6267;33.1718;29.67;50.3837;85.0648;42.1495;77.9158;25.561;38.2776;18.9314;56.3921;77.0178;74.0916;45.9958;108.9*pi/180;50.891389*pi/180];

for i=1:20
    ppm=sqrt(2^2+(3*L(i)/1000)^2);
    Sigma(i)=ppm/10;
end
Sigma(length(Sigma)+1)=7/3600*pi/180;
Sigma(length(Sigma)+1)=2*7/3600*pi/180;
for i=1:length(L)
    P(i,i)=1/(Sigma(i))^2;
end

syms x2 y2 x3 y3 x4 y4 x5 y5 x6 y6 x7 y7 x8 y8 x9 y9 x10 y10
M=[sqrt((x2-x1)^2+(y2-y1)^2);
    sqrt((x3-x1)^2+(y3-y1)^2);
    sqrt((x5-x1)^2+(y5-y1)^2);
    sqrt((x3-x2)^2+(y3-y2)^2);
    sqrt((x4-x2)^2+(y4-y2)^2);
    sqrt((x4-x3)^2+(y4-y3)^2);
    sqrt((x5-x3)^2+(y5-y3)^2);
    sqrt((x5-x4)^2+(y5-y4)^2);
    sqrt((x6-x4)^2+(y6-y4)^2);
    sqrt((x7-x4)^2+(y7-y4)^2);
    sqrt((x9-x4)^2+(y9-y4)^2);
    sqrt((x6-x5)^2+(y6-y5)^2);
    sqrt((x8-x5)^2+(y8-y5)^2);
    sqrt((x7-x6)^2+(y7-y6)^2);
    sqrt((x8-x6)^2+(y8-y6)^2);
    sqrt((x8-x7)^2+(y8-y7)^2);
    sqrt((x9-x7)^2+(y9-y7)^2);
    sqrt((x10-x7)^2+(y10-y7)^2);
    sqrt((x10-x8)^2+(y10-y8)^2);
    sqrt((x10-x9)^2+(y10-y9)^2);
    atan((x2-x1)/(y2-y1));
    atan((x1-x3)/(y1-y3))-atan((x2-x3)/(y2-y3))];
V=[x2 y2 x3 y3 x4 y4 x5 y5 x6 y6 x7 y7 x8 y8 x9 y9 x10 y10];
A = jacobian(M,V);
dx=c0';
for i=1:length(c0)
    D(i,1)=0.02;
end
while abs(dx)>D
    A=subs(A,V,c0);
    L0=subs(M,V,c0);
    for i=1:length(L)
        if L0(i)<0
            L0(i)=L0(i)+pi;
        end
        dL(i,1)=L(i)-L0(i);
    end
    dx=inv(A'*P*A)*A'*P*dL;
    for i=1:length(c0)
        c0(1,i)=c0(i)+dx(i);
    end
end

B=vpa(c0,7); % tedad arghame namayesh dade shode
Coordinate=[1000,1000];
for i=4:2:length(c0)+2
    Coordinate(i/2,1)=B(i-3);
    Coordinate(i/2,2)=B(i-2);
end
plot(Coordinate(:,1),Coordinate(:,2),'.r');
hold on
xlabel('X');
ylabel('Y');
axis equal

for i=1:length(Coordinate)
    text(Coordinate(i,1),Coordinate(i,2),num2str(i));
end
plot(Coordinate(:,1),Coordinate(:,2));
plot(Coordinate([3,5,1,3,2,4,9,7,10,8,6,4,7,8,5],1),Coordinate([3,5,1,3,2,4,9,7,10,8,6,4,7,8,5],2));
plot(Coordinate([8,9],1),Coordinate([8,9],2),'w');
axis ([900 1200 950 1220]);
grid on
title('Final Network');